/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.service.wight.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class CompositeProvider<S, SP extends Supplier<S>, SF extends UnaryOperator<S>>
implements Supplier<S> {
    private final List<SP> providers;
    private final List<SF> filters;

    public CompositeProvider(List<SP> providers, List<SF> filters) {
        if (providers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.providers = new ArrayList<SP>(providers);
        this.filters = new ArrayList<SF>(filters);
    }

    public List<SP> providers() {
        return new ArrayList<SP>(this.providers);
    }

    public List<SF> filters() {
        return new ArrayList<SF>(this.filters);
    }

    @Override
    public S get() {
        Object product = ((Supplier)this.providers.get(0)).get();
        for (UnaryOperator filter : this.filters) {
            product = filter.apply(product);
        }
        return (S)product;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[providers = " + this.providers + ", filters = " + this.filters + ']';
    }
}

